/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.model;

import com.rocoinfo.weixin.util.JsonUtils;
import com.rocoinfo.weixin.util.StringUtils;
import java.util.HashMap;
import java.util.Map;

public class ApiResult {
    private String res;
    private Map<String, Object> map;

    public static ApiResult build(String res) {
        return new ApiResult(res);
    }

    private void deserialization() {
        if (this.map != null) {
            return;
        }
        this.map = StringUtils.isNotBlank(this.res) ? JsonUtils.fromJsonAsMap(this.res, String.class, Object.class) : new HashMap<String, Object>();
    }

    public ApiResult(String res) {
        this.res = res;
    }

    public String getRawJson() {
        return this.res;
    }

    public Map<String, Object> fromJsonAsMap() {
        this.deserialization();
        return this.map;
    }

    public Object get(String key) {
        return this.fromJsonAsMap().get(key);
    }

    public boolean isSuccess() {
        this.deserialization();
        return this.map.get("errcode") == null || this.map.get("errcode").equals(0);
    }

    public Integer getErrorCode() {
        if (this.isSuccess()) {
            return 0;
        }
        return (Integer)this.map.get("errcode");
    }

    public String getErrorMsg() {
        this.deserialization();
        Object o = this.map.get("errmsg");
        if (o != null) {
            return String.valueOf(o);
        }
        return null;
    }
}

