package com.rocoinfo.weixin.model.payment.resp;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/9/18 下午2:53</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@XmlRootElement(name = "xml")
@XmlAccessorType(XmlAccessType.FIELD)
public class UnifiedOrderResp implements Serializable {

    private static final String SUCCESS_CODE = "SUCCESS";
    private static final String FAIL_CODE = "FAIL";

    /**
     * SUCCESS/FAIL
     * 此字段是通信标识，非交易标识，交易是否成功需要查看result_code来判断
     */
    @XmlElement(name = "return_code")
    private String returnCode;

    /**
     * 返回信息，如非空，为错误原因:
     * 签名失败
     * 参数格式校验错误
     */
    @XmlElement(name = "return_msg")
    private String returnMsg;

    /**
     * 调用接口提交的公众账号ID
     */
    @XmlElement(name = "appid")
    private String appid;

    /**
     * 调用接口提交的商户号
     */
    @XmlElement(name = "mch_id")
    private String mchId;

    /**
     * 自定义参数，可以为请求支付的终端设备号等
     */
    @XmlElement(name = "device_info")
    private String deviceInfo;

    /**
     * 微信返回的随机字符串
     */
    @XmlElement(name = "nonce_str")
    private String nonceStr;

    /**
     * 微信返回的签名值
     */
    @XmlElement(name = "sign")
    private String sign;

    /**
     * SUCCESS/FAIL
     */
    @XmlElement(name = "result_code")
    private String resultCode;

    /**
     * 详细参见下文错误列表
     */
    @XmlElement(name = "err_code")
    private String errCode;

    /**
     * 错误信息描述
     */
    @XmlElement(name = "err_code_des")
    private String errCodeDes;

    /**
     * 交易类型，取值为：JSAPI，NATIVE，APP等，
     */
    @XmlElement(name = "trade_type")
    private String tradeType;

    /**
     * 微信生成的预支付会话标识，用于后续接口调用中使用，该值有效期为2小时
     */
    @XmlElement(name = "prepay_id")
    private String prepayId;

    /**
     * trade_type为NATIVE时有返回，用于生成二维码，展示给用户进行扫码支付
     */
    @XmlElement(name = "code_url")
    private String codeUrl;

    public String getReturnCode() {
        return returnCode;
    }

    public UnifiedOrderResp setReturnCode(String returnCode) {
        this.returnCode = returnCode;
        return this;
    }

    public String getReturnMsg() {
        return returnMsg;
    }

    public UnifiedOrderResp setReturnMsg(String returnMsg) {
        this.returnMsg = returnMsg;
        return this;
    }

    public String getAppid() {
        return appid;
    }

    public UnifiedOrderResp setAppid(String appid) {
        this.appid = appid;
        return this;
    }

    public String getMchId() {
        return mchId;
    }

    public UnifiedOrderResp setMchId(String mchId) {
        this.mchId = mchId;
        return this;
    }

    public String getNonceStr() {
        return nonceStr;
    }

    public UnifiedOrderResp setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
        return this;
    }

    public String getSign() {
        return sign;
    }

    public UnifiedOrderResp setSign(String sign) {
        this.sign = sign;
        return this;
    }

    public String getResultCode() {
        return resultCode;
    }

    public UnifiedOrderResp setResultCode(String resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    public String getErrCode() {
        return errCode;
    }

    public UnifiedOrderResp setErrCode(String errCode) {
        this.errCode = errCode;
        return this;
    }

    public String getErrCodeDes() {
        return errCodeDes;
    }

    public UnifiedOrderResp setErrCodeDes(String errCodeDes) {
        this.errCodeDes = errCodeDes;
        return this;
    }

    public String getTradeType() {
        return tradeType;
    }

    public UnifiedOrderResp setTradeType(String tradeType) {
        this.tradeType = tradeType;
        return this;
    }

    public String getPrepayId() {
        return prepayId;
    }

    public UnifiedOrderResp setPrepayId(String prepayId) {
        this.prepayId = prepayId;
        return this;
    }

    public String getCodeUrl() {
        return codeUrl;
    }

    public UnifiedOrderResp setCodeUrl(String codeUrl) {
        this.codeUrl = codeUrl;
        return this;
    }

    /**
     * 判断return_code是否为成功
     *
     * @return
     */
    public boolean isReturnCodeSuccess() {
        return SUCCESS_CODE.equals(returnCode);
    }

    /**
     * 判断result_code是否成功
     *
     * @return
     */
    public boolean isResultCodeSuccess() {
        if (isReturnCodeSuccess()) {
            return SUCCESS_CODE.endsWith(resultCode);
        }
        return false;
    }
}
