package com.rocoinfo.weixin.msg.req;

import javax.xml.bind.annotation.XmlElement;
import java.io.Serializable;

/**
 * <dl>
 * <dd>Description: 用户接收消息的基类</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/16 下午2:20</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class BaseRequest implements Serializable {

    public BaseRequest() {
    }

    public BaseRequest(String fromUser, String toUser, String createTime, String msgType) {
        this.fromUser = fromUser;
        this.toUser = toUser;
        this.createTime = createTime;
        this.msgType = msgType;
    }

    /**
     * 消息发送人
     */
    private String fromUser;

    /**
     * 消息接收人
     */
    private String toUser;

    /**
     * 消息发送时间
     */
    private String createTime;

    /**
     * 消息类型
     */
    private String msgType;


    @XmlElement(name = "FromUserName")
    public String getFromUser() {
        return fromUser;
    }

    public void setFromUser(String fromUser) {
        this.fromUser = fromUser;
    }

    @XmlElement(name = "ToUserName")
    public String getToUser() {
        return toUser;
    }

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }

    @XmlElement(name = "CreateTime")
    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    @XmlElement(name = "MsgType")
    public String getMsgType() {
        return msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }
}
