package com.rocoinfo.weixin.msg.resp;

import com.rocoinfo.weixin.util.CDataAdapter;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * <dl>
 * <dd>Description: 回复音乐消息</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/17 下午2:09</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@XmlRootElement(name = "xml")
public class MusicResponse extends BaseResponse {

    public MusicResponse() {
    }

    public MusicResponse(String fromUser, String toUser, String createTime, String msgType, Music music) {
        super(fromUser, toUser, createTime, msgType);
        this.music = music;
    }

    /**
     * 音乐消息内容
     */
    private Music music;

    public static class Music {
        public Music() {
        }

        public Music(String title, String description, String musicUrl, String hqMusicUrl, String thumbMediaId) {
            this.title = title;
            this.description = description;
            this.musicUrl = musicUrl;
            this.hqMusicUrl = hqMusicUrl;
            this.thumbMediaId = thumbMediaId;
        }

        /**
         * 音乐标题
         */

        private String title;

        /**
         * 音乐描述
         */
        private String description;

        /**
         * 音乐链接
         */
        private String musicUrl;

        /**
         * 高质量音乐链接，WIFI环境优先使用该链接播放音乐
         */
        private String hqMusicUrl;

        /**
         * 缩略图的媒体id，通过素材管理接口上传多媒体文件，得到的id
         */
        private String thumbMediaId;

        @XmlElement(name = "Title")
        @XmlJavaTypeAdapter(CDataAdapter.class)
        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        @XmlElement(name = "Description")
        @XmlJavaTypeAdapter(CDataAdapter.class)
        public String getDescription() {
            return description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        @XmlElement(name = "MusicURL")
        @XmlJavaTypeAdapter(CDataAdapter.class)
        public String getMusicUrl() {
            return musicUrl;
        }

        public void setMusicUrl(String musicUrl) {
            this.musicUrl = musicUrl;
        }

        @XmlElement(name = "HQMusicUrl")
        @XmlJavaTypeAdapter(CDataAdapter.class)
        public String getHqMusicUrl() {
            return hqMusicUrl;
        }

        public void setHqMusicUrl(String hqMusicUrl) {
            this.hqMusicUrl = hqMusicUrl;
        }

        @XmlElement(name = "ThumbMediaId")
        @XmlJavaTypeAdapter(CDataAdapter.class)
        public String getThumbMediaId() {
            return thumbMediaId;
        }

        public void setThumbMediaId(String thumbMediaId) {
            this.thumbMediaId = thumbMediaId;
        }
    }

    @XmlElement(name = "Music")
    public Music getMusic() {
        return music;
    }

    public void setMusic(Music music) {
        this.music = music;
    }
}
