package com.rocoinfo.weixin.token;

/**
 * <dl>
 * <dd>Description: AccessToken管理器</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/6 下午1:34</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class TokenManager {

    private static TokenCacheManager cache;

    static {
        if (cache == null) {
            // 默认基于内存管理token
            cache = new DefaultTokenManager();
        }
    }

    /**
     * 注入自定义的token缓存管理
     *
     * @param t   缓存管理器
     * @param <T> 必须继承TokenCacheManager
     */
    public static <T extends TokenCacheManager> void inject(T t) {
        if (t != null)
            cache = t;
    }

    /**
     * 获取AccessToken
     *
     * @return
     */
    public static String getAccessToken() {
        return cache.get().getAccessToken();
    }

    /**
     * 清除access_token的缓存
     */
    public static void clear() {
        cache.clear();
    }
}
