package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.model.ApiResult;
import com.rocoinfo.weixin.util.HttpUtils;

/**
 * <dl>
 * <dd>Description: 获取微信服务器IP地址列表</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/15 下午3:34</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class CallbackIpApi extends BaseApi {

    private CallbackIpApi() {
        super();
    }

    private static final String GET_CALLBACK_IP_URL = "https://api.weixin.qq.com/cgi-bin/getcallbackip?access_token=";

    /**
     * 获取微信服务器IP地址列表
     *
     * @return
     */
    public static ApiResult get() {
        String url = GET_CALLBACK_IP_URL + getAccessToken();
        return ApiResult.build(HttpUtils.get(url));
    }
}
