package com.rocoinfo.weixin.util;

import javax.xml.bind.annotation.adapters.XmlAdapter;

/**
 * <dl>
 * <dd>Description: 解决pojo转xml时添加cdata的问题</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/17 上午11:02</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class CDataAdapter extends XmlAdapter<String, String> {


    @Override
    public String unmarshal(String v) throws Exception {
        return v;
    }

    /**
     * pojo -> xml时，添加cdata
     *
     * @param v value
     * @return
     * @throws Exception
     */
    @Override
    public String marshal(String v) throws Exception {
        return "<![CDATA[" + v + "]]>";

    }
}
