package com.rocoinfo.weixin.util;

import com.sun.xml.bind.marshaller.CharacterEscapeHandler;

import javax.xml.bind.*;
import javax.xml.transform.stream.StreamSource;
import java.io.*;

/**
 * <dl>
 * <dd>Description: xml工具类，提供xml和pojo之间的相互转换</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/16 上午11:19</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class XmlUtils {

    private XmlUtils() {
        super();
    }

    /**
     * pojo转xml,默认编码及utf-8
     *
     * @param o pojo
     * @return
     */
    public static String toXml(Object o) {
        String result = null;
        StringWriter writer = null;
        try {
            JAXBContext context = JAXBContext.newInstance(o.getClass());
            Marshaller m = context.createMarshaller();
            // 设置输出是否格式化，不需要可以注释掉
            m.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
            // 设置去掉生成的xml的头<?xml version="1.0" encoding="UTF-8" standalone="yes"?>
            m.setProperty(Marshaller.JAXB_FRAGMENT, Boolean.TRUE);
            m.setProperty(Marshaller.JAXB_ENCODING, "UTF-8");
            // 当添加<![CDATA[xxx]]>时，小于号和大于号会被转译成&lt,&gt;将&lt,&gt转成 <>
            m.setProperty(CharacterEscapeHandler.class.getName(), (CharacterEscapeHandler) (chars, start, len, b, writer1) -> writer1.write(chars, start, len));
            writer = new StringWriter();
            m.marshal(o, writer);
            result = writer.toString();
        } catch (JAXBException e) {
            e.printStackTrace();
        } finally {
            IOUtils.closeQuietly(writer);
        }
        return result;
    }

    /**
     * xml转pojo
     *
     * @param xml   xml
     * @param clazz class
     * @param <T>   泛型
     * @return
     */
    public static <T> T fromXml(String xml, Class<T> clazz) {
        T t = null;
        try {
            JAXBContext context = JAXBContext.newInstance(clazz);
            Unmarshaller u = context.createUnmarshaller();
            JAXBElement<T> root = u.unmarshal(new StreamSource(new StringReader(xml)), clazz);
            t = root.getValue();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return t;
    }

    /**
     * 输入流读取xml转换成pojo
     *
     * @param is    输入流
     * @param clazz class
     * @param <T>   泛型
     * @return
     */
    public static <T> T fromXml(InputStream is, Class<T> clazz) {
        T t = null;
        try {
            JAXBContext context = JAXBContext.newInstance(clazz);
            Unmarshaller u = context.createUnmarshaller();
            JAXBElement<T> root = u.unmarshal(new StreamSource(), clazz);
            t = root.getValue();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return t;
    }
}
