/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.token;

import com.rocoinfo.weixin.api.AccessTokenApi;
import com.rocoinfo.weixin.token.DefaultTokenCache;
import com.rocoinfo.weixin.token.TokenCacheManager;
import com.rocoinfo.weixin.util.StringUtils;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultTokenManager
implements TokenCacheManager<DefaultTokenCache> {
    private static final String CACHE_KEY = "token_cache_key";
    private final Map<String, DefaultTokenCache> container = new ConcurrentHashMap<String, DefaultTokenCache>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DefaultTokenCache get() {
        DefaultTokenCache token = this.container.get(CACHE_KEY);
        if (this.expire(token)) {
            Class<DefaultTokenManager> clazz = DefaultTokenManager.class;
            synchronized (DefaultTokenManager.class) {
                String tokenString;
                token = this.container.get(CACHE_KEY);
                if (this.expire(token) && StringUtils.isNotBlank(tokenString = AccessTokenApi.getString())) {
                    token = new DefaultTokenCache(tokenString);
                    token.setCreateTime(System.currentTimeMillis());
                    this.container.put(CACHE_KEY, token);
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return token;
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return token;
            }
        }
        return token;
    }

    private boolean expire(DefaultTokenCache token) {
        return token == null || token.getCreateTime() + token.getExpires() * 1000L <= System.currentTimeMillis();
    }

    @Override
    public void clear() {
        this.container.clear();
    }
}

