package com.rocoinfo.weixin.model.payment.resp;

import com.rocoinfo.weixin.model.payment.PaymentCode;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * <dl>
 * <dd>Description: 微信支付结果回调数据对象 @see <a href="https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=9_7" /></dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/9/19 下午3:35</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@XmlRootElement(name = "xml")
@XmlAccessorType(XmlAccessType.FIELD)
public class PaymentResultResp {

    /**
     * 返回状态码，SUCCESS/FAIL此字段是通信标识，非交易标识，交易是否成功需要查看result_code来判断
     */
    @XmlElement(name = "return_code")
    private String returnCode;

    /**
     * 返回信息，如非空，为错误原因
     */
    @XmlElement(name = "return_msg")
    private String returnMsg;

    /**
     * 微信分配的公众账号ID
     */
    @XmlElement(name = "appid")
    private String appid;

    /**
     * 微信支付分配的商户号
     */
    @XmlElement(name = "mch_id")
    private String mchid;

    /**
     * 微信支付分配的终端设备号
     */
    @XmlElement(name = "device_info")
    private String deviceInfo;

    /**
     * 随机字符串，不长于32位
     */
    @XmlElement(name = "nonce_str")
    private String nonceStr;

    /**
     * 签名
     */
    @XmlElement(name = "sign")
    private String sign;

    /**
     * 签名类型，目前支持HMAC-SHA256和MD5，默认为MD5
     */
    @XmlElement(name = "sign_type")
    private String signType;

    /**
     * SUCCESS/FAIL
     */
    @XmlElement(name = "result_code")
    private String resultCode;

    /**
     * 错误返回的信息描述
     */
    @XmlElement(name = "err_code")
    private String errCode;

    /**
     * 错误返回的信息描述
     */
    @XmlElement(name = "err_code_des")
    private String errCodeDes;

    /**
     * 用户在商户appid下的唯一标识
     */
    @XmlElement(name = "openid")
    private String openid;

    /**
     * 用户是否关注公众账号，Y-关注，N-未关注，仅在公众账号类型支付有效
     */
    @XmlElement(name = "is_subscribe")
    private String isSubscribe;

    /**
     * JSAPI、NATIVE、APP
     */
    @XmlElement(name = "trade_type")
    private String tradeType;

    /**
     * 银行类型，采用字符串类型的银行标识
     */
    @XmlElement(name = "bank_type")
    private String bankType;

    /**
     * 订单总金额，单位为分
     */
    @XmlElement(name = "total_fee")
    private String totalFee;

    /**
     * 应结订单金额=订单金额-非充值代金券金额，应结订单金额<=订单金额。
     */
    @XmlElement(name = "settlement_total_fee")
    private String settlementTotalFee;

    /**
     * 货币类型，符合ISO4217标准的三位字母代码，默认人民币：CNY
     */
    @XmlElement(name = "fee_type")
    private String feeType;

    /**
     * 现金支付金额订单现金支付金额
     */
    @XmlElement(name = "cash_fee")
    private String cashFee;

    /**
     * 货币类型，符合ISO4217标准的三位字母代码，默认人民币：CNY
     */
    @XmlElement(name = "cash_fee_type")
    private String cashFeeType;

    /**
     * 代金券金额<=订单金额，订单金额-代金券金额=现金支付金额
     */
    @XmlElement(name = "coupon_fee")
    private String couponFee;

    /**
     * 代金券使用数量
     */
    @XmlElement(name = "coupon_count")
    private String couponCount;


    /**
     * 微信支付订单号
     */
    @XmlElement(name = "transaction_id")
    private String transactionId;

    /**
     * 商户系统内部订单号，要求32个字符内，只能是数字、大小写字母_-|*@ ，且在同一个商户号下唯一。
     */
    @XmlElement(name = "out_trade_no")
    private String outTradeNo;

    /**
     * 商家数据包，原样返回
     */
    @XmlElement(name = "attach")
    private String attach;

    /**
     * 支付完成时间，格式为yyyyMMddHHmmss，如2009年12月25日9点10分10秒表示为20091225091010。
     */
    @XmlElement(name = "time_end")
    private String timeEnd;

    /**
     * 优惠券具体信息暂时只支持三张
     */
    @XmlElement(name = "coupon_type_1")
    private String couponType1;
    @XmlElement(name = "coupon_type_2")
    private String couponType2;
    @XmlElement(name = "coupon_type_3")
    private String couponType3;
    @XmlElement(name = "coupon_id_1")
    private String couponId1;
    @XmlElement(name = "coupon_id_2")
    private String couponId2;
    @XmlElement(name = "coupon_id_3")
    private String couponId3;
    @XmlElement(name = "coupon_fee_1")
    private String couponFee1;
    @XmlElement(name = "coupon_fee_2")
    private String couponFee2;
    @XmlElement(name = "coupon_fee_3")
    private String couponFee3;

    public String getReturnCode() {
        return returnCode;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public String getReturnMsg() {
        return returnMsg;
    }

    public void setReturnMsg(String returnMsg) {
        this.returnMsg = returnMsg;
    }

    public String getAppid() {
        return appid;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getMchid() {
        return mchid;
    }

    public void setMchid(String mchid) {
        this.mchid = mchid;
    }

    public String getDeviceInfo() {
        return deviceInfo;
    }

    public void setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
    }

    public String getNonceStr() {
        return nonceStr;
    }

    public void setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
    }

    public String getSign() {
        return sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getSignType() {
        return signType;
    }

    public void setSignType(String signType) {
        this.signType = signType;
    }

    public String getResultCode() {
        return resultCode;
    }

    public void setResultCode(String resultCode) {
        this.resultCode = resultCode;
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrCodeDes() {
        return errCodeDes;
    }

    public void setErrCodeDes(String errCodeDes) {
        this.errCodeDes = errCodeDes;
    }

    public String getOpenid() {
        return openid;
    }

    public void setOpenid(String openid) {
        this.openid = openid;
    }

    public String getIsSubscribe() {
        return isSubscribe;
    }

    public void setIsSubscribe(String isSubscribe) {
        this.isSubscribe = isSubscribe;
    }

    public String getTradeType() {
        return tradeType;
    }

    public void setTradeType(String tradeType) {
        this.tradeType = tradeType;
    }

    public String getBankType() {
        return bankType;
    }

    public void setBankType(String bankType) {
        this.bankType = bankType;
    }

    public String getTotalFee() {
        return totalFee;
    }

    public void setTotalFee(String totalFee) {
        this.totalFee = totalFee;
    }

    public String getSettlementTotalFee() {
        return settlementTotalFee;
    }

    public void setSettlementTotalFee(String settlementTotalFee) {
        this.settlementTotalFee = settlementTotalFee;
    }

    public String getFeeType() {
        return feeType;
    }

    public void setFeeType(String feeType) {
        this.feeType = feeType;
    }

    public String getCashFee() {
        return cashFee;
    }

    public void setCashFee(String cashFee) {
        this.cashFee = cashFee;
    }

    public String getCashFeeType() {
        return cashFeeType;
    }

    public void setCashFeeType(String cashFeeType) {
        this.cashFeeType = cashFeeType;
    }

    public String getCouponFee() {
        return couponFee;
    }

    public void setCouponFee(String couponFee) {
        this.couponFee = couponFee;
    }

    public String getCouponCount() {
        return couponCount;
    }

    public void setCouponCount(String couponCount) {
        this.couponCount = couponCount;
    }

    public String getTransactionId() {
        return transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getAttach() {
        return attach;
    }

    public void setAttach(String attach) {
        this.attach = attach;
    }

    public String getTimeEnd() {
        return timeEnd;
    }

    public void setTimeEnd(String timeEnd) {
        this.timeEnd = timeEnd;
    }

    public String getCouponType1() {
        return couponType1;
    }

    public void setCouponType1(String couponType1) {
        this.couponType1 = couponType1;
    }

    public String getCouponType2() {
        return couponType2;
    }

    public void setCouponType2(String couponType2) {
        this.couponType2 = couponType2;
    }

    public String getCouponType3() {
        return couponType3;
    }

    public void setCouponType3(String couponType3) {
        this.couponType3 = couponType3;
    }

    public String getCouponId1() {
        return couponId1;
    }

    public void setCouponId1(String couponId1) {
        this.couponId1 = couponId1;
    }

    public String getCouponId2() {
        return couponId2;
    }

    public void setCouponId2(String couponId2) {
        this.couponId2 = couponId2;
    }

    public String getCouponId3() {
        return couponId3;
    }

    public void setCouponId3(String couponId3) {
        this.couponId3 = couponId3;
    }

    public String getCouponFee1() {
        return couponFee1;
    }

    public void setCouponFee1(String couponFee1) {
        this.couponFee1 = couponFee1;
    }

    public String getCouponFee2() {
        return couponFee2;
    }

    public void setCouponFee2(String couponFee2) {
        this.couponFee2 = couponFee2;
    }

    public String getCouponFee3() {
        return couponFee3;
    }

    public void setCouponFee3(String couponFee3) {
        this.couponFee3 = couponFee3;
    }

    /**
     * 判断return_code是否为成功
     *
     * @return
     */
    public boolean isReturnCodeSuccess() {
        return PaymentCode.SUCCESS_CODE.equals(returnCode);
    }

    /**
     * 判断result_code是否成功
     *
     * @return
     */
    public boolean isResultCodeSuccess() {
        if (isReturnCodeSuccess()) {
            return PaymentCode.SUCCESS_CODE.endsWith(resultCode);
        }
        return false;
    }
}
