package com.rocoinfo.weixin.ticket;

/**
 * <dl>
 * <dd>Description: jsApiTicket 管理器</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/8/17 10:50</dd>
 * </dl>
 */
public class TicketManager {

    private static TicketCacheManager cache;

    static {
        if (cache == null) {
            // 默认基于内存管理 jsApiTicket
            cache = new DefaultTicketManager();
        }
    }

    /**
     * 注入自定义的 ticket 缓存管理
     *
     * @param t   缓存管理器
     * @param <T> 必须继承 TicketCacheManager
     */
    public static <T extends TicketCacheManager> void inject(T t) {
        if (t != null)
            cache = t;
    }

    /**
     * 获取 jsApiTicket
     *      1.从map中获取;
     *      2.map中没有,从远程获取
     * @return
     */
    public static String getJsApiTicket() {
        return cache.get().getJsApiTicket();
    }

    /**
     * 清除 jsApiTicket 的缓存
     */
    public static void clear() {
        cache.clear();
    }
}
