/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.api.BaseApi;
import com.rocoinfo.weixin.model.payment.req.CloseOrderReq;
import com.rocoinfo.weixin.model.payment.req.DownloadBillReq;
import com.rocoinfo.weixin.model.payment.req.PaymentBaseReq;
import com.rocoinfo.weixin.model.payment.req.UnifiedOrderReq;
import com.rocoinfo.weixin.model.payment.resp.CloseOrderResp;
import com.rocoinfo.weixin.model.payment.resp.DownloadBillResp;
import com.rocoinfo.weixin.model.payment.resp.UnifiedOrderResp;
import com.rocoinfo.weixin.util.HttpUtils;
import com.rocoinfo.weixin.util.PaymentUtils;
import com.rocoinfo.weixin.util.XmlUtils;

public class PaymentApi
extends BaseApi {
    private static final String UNIFIED_ORDER_URL = "https://api.mch.weixin.qq.com/pay/unifiedorder";
    private static final String CLOSE_ORDER_URL = "https://api.mch.weixin.qq.com/pay/closeorder";
    private static final String DOWNLOAD_BILL_URL = "https://api.mch.weixin.qq.com/pay/downloadbill";

    private PaymentApi() {
    }

    public static String generateNonceStr(int len) {
        return PaymentUtils.generateNonceStr(len);
    }

    public static <T extends PaymentBaseReq> String calculateSign(T req, String key) {
        return PaymentUtils.calculateSign(req, key);
    }

    public static UnifiedOrderResp unifiedOrder(UnifiedOrderReq req) {
        if (req == null) {
            throw new RuntimeException("\u7edf\u4e00\u4e0b\u5355\u53c2\u6570\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        String res = HttpUtils.post(UNIFIED_ORDER_URL, XmlUtils.toXml(req));
        return XmlUtils.fromXml(res, UnifiedOrderResp.class);
    }

    public static CloseOrderResp closeOrder(CloseOrderReq req) {
        if (req == null) {
            throw new RuntimeException("\u5173\u95ed\u8ba2\u5355\u53c2\u6570\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        String res = HttpUtils.post(CLOSE_ORDER_URL, XmlUtils.toXml(req));
        return XmlUtils.fromXml(res, CloseOrderResp.class);
    }

    public static DownloadBillResp downloadBill(DownloadBillReq req) {
        if (req == null) {
            throw new RuntimeException("\u4e0b\u8f7d\u5bf9\u8d26\u5355\u53c2\u6570\u5bf9\u8c61\u4e3a\u7a7a\uff01");
        }
        String res = HttpUtils.post(DOWNLOAD_BILL_URL, XmlUtils.toXml(req));
        if (res.indexOf("<") == 0) {
            return XmlUtils.fromXml(res, DownloadBillResp.class);
        }
        return new DownloadBillResp("SUCCESS", "", res);
    }
}

