/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.api.BaseApi;
import com.rocoinfo.weixin.model.ApiResult;
import com.rocoinfo.weixin.util.CollectionUtils;
import com.rocoinfo.weixin.util.HttpUtils;
import com.rocoinfo.weixin.util.JsonUtils;
import com.rocoinfo.weixin.util.MapUtils;
import com.rocoinfo.weixin.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class UserApi
extends BaseApi {
    private static final String GET_USER_INFO_URL = "https://api.weixin.qq.com/cgi-bin/user/info?access_token=";
    private static final String BATCH_GET_URL = "https://api.weixin.qq.com/cgi-bin/user/info/batchget?access_token=";
    private static final String SET_USER_REMARK_URL = "https://api.weixin.qq.com/cgi-bin/user/info/updateremark?access_token=";
    private static final String GET_USER_LIST_URL = "https://api.weixin.qq.com/cgi-bin/user/get?access_token=";

    private UserApi() {
    }

    public static ApiResult info(String openid) {
        StringBuilder url = new StringBuilder(GET_USER_INFO_URL).append(UserApi.getAccessToken()).append("&openid=").append(openid).append("&lang=zh_CN");
        return ApiResult.build(HttpUtils.get(url.toString()));
    }

    public static ApiResult batchGet(List<String> openids) {
        HashMap params = new HashMap();
        ArrayList<Map<String, String>> users = new ArrayList<Map<String, String>>();
        if (CollectionUtils.isNotEmpty(openids)) {
            for (String openid : openids) {
                users.add(MapUtils.of("openid", openid, "lang", "zh-CN"));
            }
        }
        params.put("user_list", users);
        String url = BATCH_GET_URL + UserApi.getAccessToken();
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }

    public static ApiResult setUserRemark(String openid, String remark) {
        Map<String, String> params = MapUtils.of("openid", openid, "remark", remark);
        String url = SET_USER_REMARK_URL + UserApi.getAccessToken();
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }

    public static ApiResult getUseropenids(String openid) {
        StringBuilder url = new StringBuilder(GET_USER_LIST_URL).append(UserApi.getAccessToken());
        if (StringUtils.isNotBlank(openid)) {
            url.append("&next_openid=").append(openid);
        }
        return ApiResult.build(HttpUtils.get(url.toString()));
    }
}

