/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.util;

import com.rocoinfo.weixin.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;

public final class JssdkUtils {
    private JssdkUtils() {
    }

    public static String generateNonceStr(int length) {
        String base = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    public static String generateTimestamp() {
        return Long.toString(System.currentTimeMillis() / 1000L);
    }

    public static String encryptMessageBySHA1(String message) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        if (StringUtils.isBlank(message)) {
            return "";
        }
        MessageDigest crypt = MessageDigest.getInstance("SHA-1");
        crypt.reset();
        crypt.update(message.getBytes("UTF-8"));
        return JssdkUtils.byteToStr(crypt.digest());
    }

    private static String byteToStr(byte[] byteArray) {
        String strDigest = "";
        for (int i = 0; i < byteArray.length; ++i) {
            strDigest = strDigest + JssdkUtils.byteToHexStr(byteArray[i]);
        }
        return strDigest;
    }

    private static String byteToHexStr(byte mByte) {
        char[] Digit = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        char[] tempArr = new char[]{Digit[mByte >>> 4 & 0xF], Digit[mByte & 0xF]};
        String s = new String(tempArr);
        return s;
    }
}

