package com.rocoinfo.weixin.model.payment.req;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * <dl>
 * <dd>Description: 下载对账单发送的请求</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/9/19 下午4:49</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@XmlRootElement(name = "xml")
@XmlAccessorType(XmlAccessType.FIELD)
public class DownloadBillReq {

    /**
     * 必填，微信支付分配的公众账号ID（企业号corpid即为此appId）
     */
    @XmlElement(name = "appid")
    private String appid;

    /**
     * 必填，微信支付分配的商户号
     */
    @XmlElement(name = "mch_id")
    private String mchid;

    /**
     * 选填，自定义参数，可以为终端设备号(门店号或收银设备ID)，PC网页或公众号内支付可以传"WEB"
     */
    @XmlElement(name = "device_info")
    private String deviceInfo;

    /**
     * 必填，随机字符串，长度要求在32位以内。@see <a href="https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=4_3" />
     */
    @XmlElement(name = "nonce_str")
    private String nonceStr;

    /**
     * 必填，通过签名算法计算得出的签名值。@see <a href="https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=4_3" />
     */
    @XmlElement(name = "sign")
    private String sign;

    /**
     * 选填，签名类型，默认为MD5，支持HMAC-SHA256和MD5。
     */
    @XmlElement(name = "sign_type")
    private String signType;

    /**
     * 下载对账单的日期，格式：20140603
     */
    @XmlElement(name = "bill_date")
    private String billDate;

    /**
     * ALL，返回当日所有订单信息，默认值
     * SUCCESS，返回当日成功支付的订单
     * REFUND，返回当日退款订单
     * RECHARGE_REFUND，返回当日充值退款订单（相比其他对账单多一栏“返还手续费”）
     */
    @XmlElement(name = "bill_type")
    private String billType;

    /**
     * 非必传参数，固定值：GZIP，返回格式为.gzip的压缩包账单。不传则默认为数据流形式。
     */
    @XmlElement(name = "tar_type")
    private String tarType;

    public String getAppid() {
        return appid;
    }

    public DownloadBillReq setAppid(String appid) {
        this.appid = appid;
        return this;
    }

    public String getMchid() {
        return mchid;
    }

    public DownloadBillReq setMchid(String mchid) {
        this.mchid = mchid;
        return this;
    }

    public String getDeviceInfo() {
        return deviceInfo;
    }

    public DownloadBillReq setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
        return this;
    }

    public String getNonceStr() {
        return nonceStr;
    }

    public DownloadBillReq setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
        return this;
    }

    public String getSign() {
        return sign;
    }

    public DownloadBillReq setSign(String sign) {
        this.sign = sign;
        return this;
    }

    public String getSignType() {
        return signType;
    }

    public DownloadBillReq setSignType(String signType) {
        this.signType = signType;
        return this;
    }

    public String getBillDate() {
        return billDate;
    }

    public DownloadBillReq setBillDate(String billDate) {
        this.billDate = billDate;
        return this;
    }

    public String getBillType() {
        return billType;
    }

    public DownloadBillReq setBillType(String billType) {
        this.billType = billType;
        return this;
    }

    public String getTarType() {
        return tarType;
    }

    public DownloadBillReq setTarType(String tarType) {
        this.tarType = tarType;
        return this;
    }
}
