package com.rocoinfo.weixin.model.payment.req;

import com.rocoinfo.weixin.util.CDataAdapter;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;

/**
 * <dl>
 * <dd>Description: 统一下单接口请求数据 @see <a href="https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=9_1" /></dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/9/18 上午11:12</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@XmlRootElement(name = "xml")
@XmlAccessorType(XmlAccessType.FIELD)
public class UnifiedOrderReq extends PaymentBaseReq implements Serializable {

    /**
     * 必填，微信支付分配的公众账号ID（企业号corpid即为此appId）
     */
    @XmlElement(name = "appid")
    private String appid;

    /**
     * 必填，微信支付分配的商户号
     */
    @XmlElement(name = "mch_id")
    private String mchid;

    /**
     * 选填，自定义参数，可以为终端设备号(门店号或收银设备ID)，PC网页或公众号内支付可以传"WEB"
     */
    @XmlElement(name = "device_info")
    private String deviceInfo;

    /**
     * 必填，随机字符串，长度要求在32位以内。@see <a href="https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=4_3" />
     */
    @XmlElement(name = "nonce_str")
    private String nonceStr;

    /**
     * 必填，通过签名算法计算得出的签名值。@see <a href="https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=4_3" />
     */
    @XmlElement(name = "sign")
    private String sign;

    /**
     * 选填，签名类型，默认为MD5，支持HMAC-SHA256和MD5。
     */
    @XmlElement(name = "sign_type")
    private String signType;

    /**
     * 必填，商品简单描述，该字段请按照规范传递。@see <a href="https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=4_2" />
     */
    @XmlElement(name = "body")
    private String body;

    /**
     * 选填，商品详细描述，对于使用单品优惠的商户，改字段必须按照规范上传。@see <a href="https://pay.weixin.qq.com/wiki/doc/api/danpin.php?chapter=9_102&index=2" />
     */
    @XmlElement(name = "detail")
    @XmlJavaTypeAdapter(value = CDataAdapter.class)
    private String detail;

    /**
     * 选填，附加数据，在查询API和支付通知中原样返回，可作为自定义参数使用。
     */
    @XmlElement(name = "attach")
    private String attach;

    /**
     * 必填，商户系统内部订单号，要求32个字符内，只能是数字、大小写字母_-|*@ ，且在同一个商户号下唯一。
     *
     * @see <a href="https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=4_2" />
     */
    @XmlElement(name = "out_trade_no")
    private String outTradeNo;

    /**
     * 选填，货币币种，符合ISO 4217标准的三位字母代码，默认人民币：CNY。
     */
    @XmlElement(name = "fee_type")
    private String feeType;

    /**
     * 必填，订单总金额，单位为分。@see <a href="https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=4_2"></a>
     */
    @XmlElement(name = "total_fee")
    private String totalFee;

    /**
     * 必填，APP和网页支付提交用户端ip，Native支付填调用微信支付API的机器IP。
     */
    @XmlElement(name = "spbill_create_ip")
    private String spbillCreateIp;

    /**
     * 选填，订单生成时间，格式为yyyyMMddHHmmss，如2009年12月25日9点10分10秒表示为20091225091010。
     */
    @XmlElement(name = "time_start")
    private String timeStart;

    /**
     * 选填，订单失效时间，格式为yyyyMMddHHmmss，如2009年12月27日9点10分10秒表示为20091227091010。
     * 注意：最短失效时间间隔必须大于5分钟
     */
    @XmlElement(name = "time_expire")
    private String timeExpire;

    /**
     * 选填，订单优惠标记，使用代金券或立减优惠功能时需要的参数。
     */
    @XmlElement(name = "goods_tag")
    private String goodsTag;

    /**
     * 必填，异步接收微信支付结果通知的回调地址，通知url必须为外网可访问的url，不能携带参数。
     */
    @XmlElement(name = "notify_url")
    private String notifyUrl;

    /**
     * 必填，交易类型，取值如下：JSAPI，NATIVE，APP等。@see <a href="https://pay.weixin.qq.com/wiki/doc/api/jsapi.php?chapter=4_2" />
     */
    @XmlElement(name = "trade_type")
    private String tradeType;

    /**
     * 选填，商品id，trade_type=NATIVE时（即扫码支付），此参数必传。此参数为二维码中包含的商品ID，商户自行定义。
     */
    @XmlElement(name = "product_id")
    private String productId;

    /**
     * 选填，指定支付方式，上传此参数no_credit--可限制用户不能使用信用卡支付。
     */
    @XmlElement(name = "limit_pay")
    private String limitPay;

    /**
     * 选填，trade_type=JSAPI时（即公众号支付），此参数必传，此参数为微信用户在商户对应appid下的唯一标识。openid如何获取。
     */
    @XmlElement(name = "openid")
    private String openid;

    /**
     * 选填，场景信息，该字段用于上报场景信息，目前支持上报实际门店信息。该字段为JSON对象数据，对象格式为{"store_info":{"id": "门店ID","name": "名称","area_code": "编码","address": "地址" }}。
     */
    @XmlElement(name = "scene_info")
    private String sceneInfo;


    public String getAppid() {
        return appid;
    }

    public UnifiedOrderReq setAppid(String appid) {
        this.appid = appid;
        return this;
    }


    public String getMchid() {
        return mchid;
    }

    public UnifiedOrderReq setMchid(String mchid) {
        this.mchid = mchid;
        return this;
    }

    public String getDeviceInfo() {
        return deviceInfo;
    }

    public UnifiedOrderReq setDeviceInfo(String deviceInfo) {
        this.deviceInfo = deviceInfo;
        return this;
    }

    public String getNonceStr() {
        return nonceStr;
    }

    public UnifiedOrderReq setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
        return this;
    }

    public String getSign() {
        return sign;
    }

    public UnifiedOrderReq setSign(String sign) {
        this.sign = sign;
        return this;
    }

    public String getSignType() {
        return signType;
    }

    public UnifiedOrderReq setSignType(String signType) {
        this.signType = signType;
        return this;
    }

    public String getBody() {
        return body;
    }

    public UnifiedOrderReq setBody(String body) {
        this.body = body;
        return this;
    }

    public String getDetail() {
        return detail;
    }

    public UnifiedOrderReq setDetail(String detail) {
        this.detail = detail;
        return this;
    }

    public String getAttach() {
        return attach;
    }

    public UnifiedOrderReq setAttach(String attach) {
        this.attach = attach;
        return this;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public UnifiedOrderReq setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
        return this;
    }

    public String getFeeType() {
        return feeType;
    }

    public UnifiedOrderReq setFeeType(String feeType) {
        this.feeType = feeType;
        return this;
    }

    public String getTotalFee() {
        return totalFee;
    }

    public UnifiedOrderReq setTotalFee(String totalFee) {
        this.totalFee = totalFee;
        return this;
    }

    public String getSpbillCreateIp() {
        return spbillCreateIp;
    }

    public UnifiedOrderReq setSpbillCreateIp(String spbillCreateIp) {
        this.spbillCreateIp = spbillCreateIp;
        return this;
    }

    public String getTimeStart() {
        return timeStart;
    }

    public UnifiedOrderReq setTimeStart(String timeStart) {
        this.timeStart = timeStart;
        return this;
    }

    public String getTimeExpire() {
        return timeExpire;
    }

    public UnifiedOrderReq setTimeExpire(String timeExpire) {
        this.timeExpire = timeExpire;
        return this;
    }

    public String getGoodsTag() {
        return goodsTag;
    }

    public UnifiedOrderReq setGoodsTag(String goodsTag) {
        this.goodsTag = goodsTag;
        return this;
    }

    public String getNotifyUrl() {
        return notifyUrl;
    }

    public UnifiedOrderReq setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
        return this;
    }

    public String getTradeType() {
        return tradeType;
    }

    public UnifiedOrderReq setTradeType(String tradeType) {
        this.tradeType = tradeType;
        return this;
    }

    public String getProductId() {
        return productId;
    }

    public UnifiedOrderReq setProductId(String productId) {
        this.productId = productId;
        return this;
    }

    public String getLimitPay() {
        return limitPay;
    }

    public UnifiedOrderReq setLimitPay(String limitPay) {
        this.limitPay = limitPay;
        return this;
    }

    public String getOpenid() {
        return openid;
    }

    public UnifiedOrderReq setOpenid(String openid) {
        this.openid = openid;
        return this;
    }

    public String getSceneInfo() {
        return sceneInfo;
    }

    public UnifiedOrderReq setSceneInfo(String sceneInfo) {
        this.sceneInfo = sceneInfo;
        return this;
    }
}