package com.rocoinfo.weixin.msg.resp;

import com.rocoinfo.weixin.util.CDataAdapter;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * <dl>
 * <dd>Description: 回复文本消息</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/17 上午10:56</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@XmlRootElement(name = "xml")
public class TextResponse extends BaseResponse {

    public TextResponse() {
        super();
    }

    public TextResponse(String fromUser, String toUser, String createTime, String msgType, String content) {
        super(fromUser, toUser, createTime, msgType);
        this.content = content;
    }

    /**
     * 回复的消息内容（换行：在content中能够换行，微信客户端就支持换行显示）
     */
    private String content;

    @XmlElement(name = "Content")
    @XmlJavaTypeAdapter(CDataAdapter.class)
    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }
}
