package com.rocoinfo.weixin.util;

import com.rocoinfo.weixin.model.payment.req.PaymentBaseReq;

import javax.xml.bind.annotation.XmlElement;
import java.lang.reflect.Field;
import java.util.*;

/**
 * <dl>
 * <dd>Description: </dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/9/18 下午1:16</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class PaymentUtils {

    /**
     * 生成随机串
     *
     * @return 随机串
     */
    public static String generateNonceStr(int length) {
        String base = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789";
        Random random = new Random();
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; i++) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }

    /**
     * 计算微信支付的签名
     *
     * @param req 微信支付请求的数据
     * @return
     */
    public static <T extends PaymentBaseReq> String calculateSign(T req, String key) {
        if (req == null) {
            return StringUtils.BLANK;
        }
        // 利用反射，反射字段,并将字段拼接成 key=value的形式
        List<Field> fields = new ArrayList<>(Arrays.asList(req.getClass().getDeclaredFields()));
        List<String> kvs = new ArrayList<>();
        fields.forEach(field -> {
            field.setAccessible(true);
            try {
                XmlElement xmlElement = field.getAnnotation(XmlElement.class);
                Object obj = field.get(req);
                if (obj != null && !"sign".equals(xmlElement.name())) {
                    kvs.add(xmlElement.name() + "=" + String.valueOf(obj) + "&");
                }
            } catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        });

        if (kvs.size() == 0) {
            return StringUtils.BLANK;
        }

        // 按字典顺序排序
        Collections.sort(kvs);

        System.out.println(kvs);

        // 拼接字符串
        StringBuilder sb = new StringBuilder("");
        kvs.forEach(sb::append);
        sb.append("key=" + key); // 需要带上key

        return MD5Utils.md5(sb.toString());
    }
}
