/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.api.BaseApi;
import com.rocoinfo.weixin.model.ApiResult;
import com.rocoinfo.weixin.util.HttpUtils;
import com.rocoinfo.weixin.util.JsonUtils;
import com.rocoinfo.weixin.util.MapUtils;
import java.util.List;
import java.util.Map;

public class GroupApi
extends BaseApi {
    private static final String CREATE_GROUP_URL = "https://api.weixin.qq.com/cgi-bin/groups/create?access_token=";
    private static final String CREATE_PARAMS_JSON = "{\"group\":{\"name\":\"%s\"}}";
    private static final String GET_URL = "https://api.weixin.qq.com/cgi-bin/groups/get?access_token=";
    private static final String USER_PLACE_GROUPID_URL = "https://api.weixin.qq.com/cgi-bin/groups/getid?access_token=";
    private static final String UPDATE_GROUP_URL = "https://api.weixin.qq.com/cgi-bin/groups/update?access_token=";
    private static final String MOVE_MEMBER_URL = "https://api.weixin.qq.com/cgi-bin/groups/members/update?access_token=";
    private static final String BATCH_MOVE_MEMBER_URL = "https://api.weixin.qq.com/cgi-bin/groups/members/batchupdate?access_token=";
    private static final String DELETE_GROUP_URL = "https://api.weixin.qq.com/cgi-bin/groups/delete?access_token=";

    private GroupApi() {
    }

    public static ApiResult create(String name) {
        String url = CREATE_GROUP_URL + GroupApi.getAccessToken();
        return ApiResult.build(HttpUtils.post(url, String.format(CREATE_PARAMS_JSON, name)));
    }

    public static ApiResult all() {
        String url = GET_URL + GroupApi.getAccessToken();
        return ApiResult.build(HttpUtils.get(url));
    }

    public static ApiResult userGroup(String openid) {
        Map<String, String> params = MapUtils.of("openid", openid);
        String url = USER_PLACE_GROUPID_URL + GroupApi.getAccessToken();
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }

    public static ApiResult update(String id, String name) {
        Map<String, String> group = MapUtils.of("id", id, "name", name);
        Map<String, Map<String, String>> params = MapUtils.of("group", group);
        String url = UPDATE_GROUP_URL + GroupApi.getAccessToken();
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }

    public static ApiResult move(String openid, String groupid) {
        Map<String, String> params = MapUtils.of("openid", openid, "to_groupid", groupid);
        String url = MOVE_MEMBER_URL + GroupApi.getAccessToken();
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }

    public static ApiResult batchMoveMember(List<String> openids, String groupid) {
        Map<String, String> params = MapUtils.of("openid_list", openids, "to_groupid", groupid);
        String url = BATCH_MOVE_MEMBER_URL + GroupApi.getAccessToken();
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }

    public static ApiResult delete(String id) {
        Map<String, String> group = MapUtils.of("id", id);
        Map<String, Map<String, String>> params = MapUtils.of("group", group);
        String url = DELETE_GROUP_URL + GroupApi.getAccessToken();
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }
}

