/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.api.BaseApi;
import com.rocoinfo.weixin.enums.MediaType;
import com.rocoinfo.weixin.model.ApiResult;
import com.rocoinfo.weixin.model.MediaArticle;
import com.rocoinfo.weixin.model.MediaFile;
import com.rocoinfo.weixin.util.HttpUtils;
import com.rocoinfo.weixin.util.JsonUtils;
import com.rocoinfo.weixin.util.MapUtils;
import java.io.File;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MediaApi
extends BaseApi {
    private static final String UPLOAD_URL = "https://api.weixin.qq.com/cgi-bin/media/upload?access_token=";
    private static final String GET_URL = "https://api.weixin.qq.com/cgi-bin/media/get?access_token=";
    private static final String ADD_NEWS_URL = "https://api.weixin.qq.com/cgi-bin/material/add_news?access_token=";
    private static final String ADD_MATERIAL_URL = "https://api.weixin.qq.com/cgi-bin/material/add_material?access_token=";
    private static final String UPLOAD_VIDEO_URL = "https://file.api.weixin.qq.com/cgi-bin/media/uploadvideo?access_token=";
    private static final String UPLOAD_NEWS = "https://api.weixin.qq.com/cgi-bin/media/uploadnews?access_token=";
    private static final String UPLOAD_IMG_URL = "https://api.weixin.qq.com/cgi-bin/media/uploadimg?access_token=";
    private static final String GET_MATERIAL_URL = "https://api.weixin.qq.com/cgi-bin/material/get_material?access_token=";
    private static final String DEL_MATERIAL_URL = "https://api.weixin.qq.com/cgi-bin/material/del_material?access_token=";
    private static final String UPDATE_NEWS_URL = "https://api.weixin.qq.com/cgi-bin/material/update_news?access_token=";
    private static final String GET_MATERIALCOUNT_URL = "https://api.weixin.qq.com/cgi-bin/material/get_materialcount?access_token=";
    private static final String BATCHGET_MATERIAL_URL = "https://api.weixin.qq.com/cgi-bin/material/batchget_material?access_token=";

    public static ApiResult upload(MediaType type, File file) {
        String url = UPLOAD_URL + MediaApi.getAccessToken() + "&type=" + type.getValue();
        return ApiResult.build(HttpUtils.upload(url, file, null));
    }

    public static MediaFile get(String mediaId) {
        String url = GET_URL + MediaApi.getAccessToken() + "&media_id=" + mediaId;
        return HttpUtils.download(url);
    }

    public static ApiResult addNews(List<MediaArticle> articles) {
        String url = ADD_NEWS_URL + MediaApi.getAccessToken();
        Map<String, List<MediaArticle>> dataMap = MapUtils.of("articles", articles);
        String jsonResult = HttpUtils.post(url, JsonUtils.toJson(dataMap));
        return ApiResult.build(jsonResult);
    }

    public static ApiResult addMaterial(File file) {
        String url = ADD_MATERIAL_URL + MediaApi.getAccessToken();
        return ApiResult.build(HttpUtils.upload(url, file, null));
    }

    public static ApiResult uploadVideo(String mediaId, String title, String description) {
        String url = UPLOAD_VIDEO_URL + MediaApi.getAccessToken();
        HashMap<String, String> mapData = new HashMap<String, String>();
        mapData.put("media_id", mediaId);
        mapData.put("title", title);
        mapData.put("description", description);
        String jsonResult = HttpUtils.post(url, JsonUtils.toJson(mapData));
        return ApiResult.build(jsonResult);
    }

    public static ApiResult uploadNews(List<MediaArticle> MediaArticle2) {
        String url = UPLOAD_NEWS + MediaApi.getAccessToken();
        HashMap<String, List<MediaArticle>> dataMap = new HashMap<String, List<MediaArticle>>();
        dataMap.put("articles", MediaArticle2);
        String jsonResult = HttpUtils.post(url, JsonUtils.toJson(dataMap));
        return ApiResult.build(jsonResult);
    }

    public static ApiResult uploadImg(File imgFile) {
        String url = UPLOAD_IMG_URL + MediaApi.getAccessToken();
        String jsonResult = HttpUtils.upload(url, imgFile, null);
        return ApiResult.build(jsonResult);
    }

    public static ApiResult addMaterial(File file, String title, String introduction) {
        String url = ADD_MATERIAL_URL + MediaApi.getAccessToken();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("title", title);
        dataMap.put("introduction", introduction);
        String jsonResult = HttpUtils.upload(url, file, JsonUtils.toJson(dataMap));
        return ApiResult.build(jsonResult);
    }

    public static InputStream getMaterial(String media_id) {
        String url = GET_MATERIAL_URL + MediaApi.getAccessToken();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("media_id", media_id);
        return HttpUtils.download(url, JsonUtils.toJson(dataMap));
    }

    public static ApiResult delMaterial(String media_id) {
        String url = DEL_MATERIAL_URL + MediaApi.getAccessToken();
        HashMap<String, String> dataMap = new HashMap<String, String>();
        dataMap.put("media_id", media_id);
        String jsonResult = HttpUtils.post(url, JsonUtils.toJson(dataMap));
        return ApiResult.build(jsonResult);
    }

    public static ApiResult updateNews(String media_id, int index, MediaArticle MediaArticle2) {
        String url = UPDATE_NEWS_URL + MediaApi.getAccessToken();
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("media_id", media_id);
        dataMap.put("index", index);
        dataMap.put("articles", MediaArticle2);
        String jsonResult = HttpUtils.post(url, JsonUtils.toJson(dataMap));
        return ApiResult.build(jsonResult);
    }

    public static ApiResult getMaterialCount() {
        String url = GET_MATERIALCOUNT_URL + MediaApi.getAccessToken();
        String jsonResult = HttpUtils.get(url);
        return ApiResult.build(jsonResult);
    }

    public static ApiResult batchGetMaterial(MediaType mediaType, int offset, int count) {
        String url = BATCHGET_MATERIAL_URL + MediaApi.getAccessToken();
        if (offset < 0) {
            offset = 0;
        }
        if (count > 20) {
            count = 20;
        }
        if (count < 1) {
            count = 1;
        }
        HashMap<String, Object> dataMap = new HashMap<String, Object>();
        dataMap.put("type", mediaType.getValue());
        dataMap.put("offset", offset);
        dataMap.put("count", count);
        String jsonResult = HttpUtils.post(url, JsonUtils.toJson(dataMap));
        return ApiResult.build(jsonResult);
    }
}

