package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.config.ParamManager;
import com.rocoinfo.weixin.model.ApiResult;
import com.rocoinfo.weixin.util.HttpUtils;

/**
 * <dl>
 * <dd>Description: 获取access_token的接口</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/6 下午3:01</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class AccessTokenApi {

    /**
     * 获取accss_token的url
     */
    private static final String FETCH_TOKEN = "https://api.weixin.qq.com/cgi-bin/token?grant_type=client_credential&appid=%s&secret=%s";

    private AccessTokenApi() {
        super();
    }

    /**
     * 获取access_token的结果集
     *
     * @return
     */
    public static ApiResult get() {
        String url = String.format(FETCH_TOKEN, ParamManager.getAppid(), ParamManager.getSecret());
        return ApiResult.build(HttpUtils.get(url));
    }

    /**
     * 获取字符串格式的access_token
     *
     * @return
     */
    public static String getString() {
        String token = null;
        ApiResult res = get();
        if (res.isSuccess()) {
            token = String.valueOf(res.get("access_token"));
        }
        return token;
    }
}
