package com.rocoinfo.weixin.model.payment.resp;

import com.rocoinfo.weixin.model.payment.PaymentCode;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;

/**
 * <dl>
 * <dd>Description: 订单关闭接口微信返回数据</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/9/19 下午1:06</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@XmlRootElement(name = "xml")
@XmlAccessorType(XmlAccessType.FIELD)
public class CloseOrderResp implements Serializable {

    /**
     * SUCCESS/FAIL
     * 此字段是通信标识，非交易标识，交易是否成功需要查看result_code来判断
     */
    @XmlElement(name = "return_code")
    private String returnCode;

    /**
     * 返回信息，如非空，为错误原因:
     * 签名失败
     * 参数格式校验错误
     */
    @XmlElement(name = "return_msg")
    private String returnMsg;

    /**
     * 调用接口提交的公众账号ID
     */
    @XmlElement(name = "appid")
    private String appid;

    /**
     * 调用接口提交的商户号
     */
    @XmlElement(name = "mch_id")
    private String mchId;

    /**
     * 微信返回的随机字符串
     */
    @XmlElement(name = "nonce_str")
    private String nonceStr;

    /**
     * 微信返回的签名值
     */
    @XmlElement(name = "sign")
    private String sign;

    /**
     * SUCCESS/FAIL
     */
    @XmlElement(name = "result_code")
    private String resultCode;

    /**
     * 对于业务执行的详细描述
     */
    @XmlElement(name = "result_msg")
    private String resultMsg;

    /**
     * 详细参见下文错误列表
     */
    @XmlElement(name = "err_code")
    private String errCode;

    /**
     * 错误信息描述
     */
    @XmlElement(name = "err_code_des")
    private String errCodeDes;

    public String getReturnCode() {
        return returnCode;
    }

    public CloseOrderResp setReturnCode(String returnCode) {
        this.returnCode = returnCode;
        return this;
    }

    public String getReturnMsg() {
        return returnMsg;
    }

    public CloseOrderResp setReturnMsg(String returnMsg) {
        this.returnMsg = returnMsg;
        return this;
    }

    public String getAppid() {
        return appid;
    }

    public CloseOrderResp setAppid(String appid) {
        this.appid = appid;
        return this;
    }

    public String getMchId() {
        return mchId;
    }

    public CloseOrderResp setMchId(String mchId) {
        this.mchId = mchId;
        return this;
    }

    public String getNonceStr() {
        return nonceStr;
    }

    public CloseOrderResp setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
        return this;
    }

    public String getSign() {
        return sign;
    }

    public CloseOrderResp setSign(String sign) {
        this.sign = sign;
        return this;
    }

    public String getResultCode() {
        return resultCode;
    }

    public CloseOrderResp setResultCode(String resultCode) {
        this.resultCode = resultCode;
        return this;
    }

    public String getResultMsg() {
        return resultMsg;
    }

    public CloseOrderResp setResultMsg(String resultMsg) {
        this.resultMsg = resultMsg;
        return this;
    }

    public String getErrCode() {
        return errCode;
    }

    public CloseOrderResp setErrCode(String errCode) {
        this.errCode = errCode;
        return this;
    }

    public String getErrCodeDes() {
        return errCodeDes;
    }

    public CloseOrderResp setErrCodeDes(String errCodeDes) {
        this.errCodeDes = errCodeDes;
        return this;
    }

    /**
     * 判断return_code是否为成功
     *
     * @return
     */
    public boolean isReturnCodeSuccess() {
        return PaymentCode.SUCCESS_CODE.equals(returnCode);
    }

    /**
     * 判断result_code是否成功
     *
     * @return
     */
    public boolean isResultCodeSuccess() {
        if (isReturnCodeSuccess()) {
            return PaymentCode.SUCCESS_CODE.endsWith(resultCode);
        }
        return false;
    }
}
