package com.rocoinfo.weixin.model.payment.resp;

import com.rocoinfo.weixin.model.payment.PaymentCode;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

/**
 * <dl>
 * <dd>Description: 下载对账单返回的数据</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/9/19 下午4:41</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@XmlRootElement(name = "xml")
@XmlAccessorType(XmlAccessType.FIELD)
public class DownloadBillResp {

    /**
     * FAIL，只有错误状态下才会有return_code和return_msg
     */
    @XmlElement(name = "return_code")
    private String returnCode;

    /**
     * 返回信息，如非空，为错误原因
     */
    @XmlElement(name = "return_msg")
    private String returnMsg;

    private String content;

    public DownloadBillResp(String code, String msg, String content) {
        this.returnCode = code;
        this.returnMsg = msg;
        this.content = content;
    }

    public String getReturnCode() {
        return returnCode;
    }

    public void setReturnCode(String returnCode) {
        this.returnCode = returnCode;
    }

    public String getReturnMsg() {
        return returnMsg;
    }

    public void setReturnMsg(String returnMsg) {
        this.returnMsg = returnMsg;
    }

    public String getContent() {
        return content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public boolean isSuccess() {
        return PaymentCode.SUCCESS_CODE.equals(returnCode);
    }
}
