package com.rocoinfo.weixin.msg.resp;

import com.rocoinfo.weixin.util.CDataAdapter;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.io.Serializable;

/**
 * <dl>
 * <dd>Description: 消息回复基类</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/15 下午5:25</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@XmlRootElement(name = "xml")
public class BaseResponse implements Serializable {

    public BaseResponse() {
    }

    public BaseResponse(String fromUser, String toUser, String createTime, String msgType) {
        this.fromUser = fromUser;
        this.toUser = toUser;
        this.createTime = createTime;
        this.msgType = msgType;
    }

    /**
     * 消息发送人
     */
    private String fromUser;

    /**
     * 消息接收人(微信用户)
     */
    private String toUser;

    /**
     * 消息发送时间
     */
    private String createTime;

    /**
     * 消息类型
     */
    private String msgType;


    @XmlElement(name = "FromUserName")
    @XmlJavaTypeAdapter(CDataAdapter.class)
    public String getFromUser() {
        return fromUser;
    }

    public void setFromUser(String fromUser) {
        this.fromUser = fromUser;
    }

    @XmlElement(name = "ToUserName")
    @XmlJavaTypeAdapter(CDataAdapter.class)
    public String getToUser() {
        return toUser;
    }

    public void setToUser(String toUser) {
        this.toUser = toUser;
    }

    @XmlElement(name = "CreateTime")
    public String getCreateTime() {
        return createTime;
    }

    public void setCreateTime(String createTime) {
        this.createTime = createTime;
    }

    @XmlElement(name = "MsgType")
    @XmlJavaTypeAdapter(CDataAdapter.class)
    public String getMsgType() {
        return msgType;
    }

    public void setMsgType(String msgType) {
        this.msgType = msgType;
    }

}
