package com.rocoinfo.weixin.msg.resp;

import com.rocoinfo.weixin.util.CDataAdapter;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * <dl>
 * <dd>Description: 回复图片消息</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/17 下午12:46</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@XmlRootElement(name = "xml")
public class PicResponse extends BaseResponse {

    public PicResponse() {
        super();
    }

    public PicResponse(String fromUser, String toUser, String createTime, String msgType, Image image) {
        super(fromUser, toUser, createTime, msgType);
        this.image = image;
    }

    /**
     * 图片消息内容
     */
    private Image image;


    /**
     * 图片消息
     */
    public static class Image {

        public Image() {
        }

        public Image(String mediaId) {
            this.mediaId = mediaId;
        }

        /**
         * 通过素材管理接口上传多媒体文件，得到的id
         */
        private String mediaId;

        @XmlElement(name = "MediaId")
        @XmlJavaTypeAdapter(CDataAdapter.class)
        public String getMediaId() {
            return mediaId;
        }

        public void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }
    }

    @XmlElement(name = "Image")
    public Image getImage() {
        return image;
    }

    public void setImage(Image image) {
        this.image = image;
    }
}
