package com.rocoinfo.weixin.util;

import java.util.HashMap;
import java.util.Map;

/**
 * <dl>
 * <dd>Description: Map的工具类</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/7 下午1:19</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class MapUtils {

    /**
     * 构建一个hashmap，存放传入的k，v
     *
     * @param k   key
     * @param v   value
     * @param <K> key的泛型
     * @param <V> value的泛型
     * @return
     */
    public static <K, V> Map<K, V> of(K k, V v) {
        Map<K, V> map = new HashMap<>();
        checkNotNullAndPut(map, k, v);
        return map;
    }

    /**
     * 构建一个hashmap，存放传入的k，v
     *
     * @param k1  key1
     * @param v2  value2
     * @param k2  key1
     * @param v2  value2
     * @param <K> key的泛型
     * @param <V> value的泛型
     * @return
     */
    public static <K, V> Map<K, V> of(K k1, V v1, K k2, V v2) {
        Map<K, V> map = new HashMap<>();
        checkNotNullAndPut(map, k1, v1);
        checkNotNullAndPut(map, k2, v2);
        return map;
    }

    /**
     * 如果key不为null,value不为null，则将key/value放入map
     *
     * @param map map
     * @param k   key
     * @param v   value
     * @param <K> key类型
     * @param <V> value类型
     */
    private static <K, V> void checkNotNullAndPut(Map<K, V> map, K k, V v) {
        if (k != null && v != null) {
            map.put(k, v);
        }
    }
}
