/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.util;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapType;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonUtils {
    public static final String STRING_EMPTY = "";
    public static final ObjectMapper mapper = new ObjectMapper();

    private JsonUtils() {
    }

    public static String toJson(Object obj) {
        String json;
        try {
            json = mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return STRING_EMPTY;
        }
        return json;
    }

    public static <T> T fromJson(String json, Class<T> clazz) {
        try {
            return (T)mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <K, V> Map<K, V> fromJsonAsMap(String json, Class<K> keyClass, Class<V> valueClass) {
        MapType type = mapper.getTypeFactory().constructMapType(Map.class, keyClass, valueClass);
        try {
            Map map = (Map)mapper.readValue(json, (JavaType)type);
            return map;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new HashMap();
        }
    }

    public static <T> List<T> fromJsonAsList(String json, Class<T> clazz) {
        CollectionType type = mapper.getTypeFactory().constructCollectionType(List.class, clazz);
        try {
            return (List)mapper.readValue(json, (JavaType)type);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static {
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
    }
}

