package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.model.ApiResult;
import com.rocoinfo.weixin.util.HttpUtils;
import com.rocoinfo.weixin.util.JsonUtils;
import com.rocoinfo.weixin.util.MapUtils;

import java.util.Map;

/**
 * <dl>
 * <dd>Description: 菜单管理接口</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/6 上午10:58</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class MenuApi extends BaseApi {


    /**
     * 创建菜单请求url
     */
    private static final String MENU_CREATE_URL = "https://api.weixin.qq.com/cgi-bin/menu/create?access_token=";

    private MenuApi() {
        super();
    }

    /**
     * 创建菜单（注意会覆盖原来的菜单）
     *
     * @param menus 自定义菜单的json串
     * @return 返回创建结果
     */
    public static ApiResult create(String menus) {
        String url = MENU_CREATE_URL + getAccessToken();
        return ApiResult.build(HttpUtils.post(url, menus));
    }

    /**
     * 获取菜单请求url
     */
    private static final String MENU_GET_URL = "https://api.weixin.qq.com/cgi-bin/menu/get?access_token=";

    /**
     * 获取菜单列表
     *
     * @return 自定义菜单的JSON串
     */
    public static ApiResult get() {
        String url = MENU_GET_URL + getAccessToken();
        return ApiResult.build(HttpUtils.get(url));
    }

    /**
     * 删除菜单的url
     */
    private static final String MENU_DELETE_URL = "https://api.weixin.qq.com/cgi-bin/menu/delete?access_token=";

    /**
     * 删除菜单接口,调用此接口会删除默认菜单及全部个性化菜单
     *
     * @return
     */
    public static ApiResult delete() {
        String url = MENU_DELETE_URL + getAccessToken();
        return ApiResult.build(HttpUtils.get(url));
    }

    /**
     * 创建个性化菜单url
     */
    private static final String MENU_ADD_CONDITIONAL_URL = "https://api.weixin.qq.com/cgi-bin/menu/addconditional?access_token=";

    /**
     * 创建个性化菜单
     *
     * @param menuJson 菜单json串
     * @return {ApiResult}
     */
    public static ApiResult addConditionMenu(String menuJson) {
        String url = MENU_ADD_CONDITIONAL_URL + getAccessToken();
        return ApiResult.build(HttpUtils.post(url, menuJson));
    }

    /**
     * 删除个性化菜单的url
     */
    private static final String MENU_DELETE_CONDITION_URL = "https://api.weixin.qq.com/cgi-bin/menu/delconditional?access_token=";

    /**
     * 删除个性化菜单
     *
     * @return {ApiResult}
     */
    public static ApiResult deleteConditionMenu(String menuId) {
        Map<String, String> params = MapUtils.of("menuid", menuId);
        String url = MENU_DELETE_CONDITION_URL + getAccessToken();
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }

    /**
     * 测试用户是否匹配个性化菜单的url
     */
    private static final String TRY_MATCH_URL = "https://api.weixin.qq.com/cgi-bin/menu/trymatch?access_token=";

    /**
     * 测试用户是否匹配个性化菜单
     *
     * @param openid openid，也可以是粉丝的微信号。
     * @return {ApiResult}
     */
    public static ApiResult tryMatch(String openid) {
        Map<String, String> params = MapUtils.of("user_id", openid);
        String url = TRY_MATCH_URL + getAccessToken();
        return ApiResult.build(HttpUtils.post(url, JsonUtils.toJson(params)));
    }

    /**
     * 获取菜单配置接口
     */
    private static final String GET_CURRENT_SELF_MENUINFO_URL = "https://api.weixin.qq.com/cgi-bin/get_current_selfmenu_info?access_token=";

    /**
     * 获取菜单配置接口
     *
     * @return {ApiResult}
     */
    public static ApiResult getCurrentSelfMenuInfo() {
        String url = GET_CURRENT_SELF_MENUINFO_URL + getAccessToken();
        return ApiResult.build(HttpUtils.get(url));
    }
}
