package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.model.ApiResult;
import com.rocoinfo.weixin.util.HttpUtils;

/**
 * <dl>
 * <dd>Description: 消息相关Api</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/7 下午4:36</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class MessageApi extends BaseApi {

    /**
     * 发送模板消息的微信请求地址
     */
    private static String SEND_TEMPLATE_URL = "https://api.weixin.qq.com/cgi-bin/message/template/send?access_token=";

    private MessageApi() {
        super();
    }

    /**
     * 发送模板消息
     *
     * @param json 发送模板消息数据
     * @return 返回发送结果
     */
    public static ApiResult sendTemplateMsg(String json) {
        String url = SEND_TEMPLATE_URL + getAccessToken();
        return ApiResult.build(HttpUtils.post(url, json));
    }
}
