package com.rocoinfo.weixin.model.payment.req;

import com.rocoinfo.weixin.util.XmlUtils;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import java.io.Serializable;

/**
 * <dl>
 * <dd>Description: 微信关闭订单接口</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/9/19 下午12:53</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@XmlRootElement(name = "xml")
@XmlAccessorType(XmlAccessType.FIELD)
public class CloseOrderReq extends PaymentBaseReq implements Serializable {

    /**
     * 必填，微信分配的公众账号ID（企业号corpid即为此appId）
     */
    @XmlElement(name = "appid")
    private String appid;

    /**
     * 必填，微信支付分配的商户号
     */
    @XmlElement(name = "mch_id")
    private String mchid;

    /**
     * 必填，商户系统内部订单号，要求32个字符内，只能是数字、大小写字母_-|*@ ，且在同一个商户号下唯一。
     */
    @XmlElement(name = "out_trade_no")
    private String outTradeNo;

    /**
     * 必填，随机字符串，不长于32位
     */
    @XmlElement(name = "nonce_str")
    private String nonceStr;

    /**
     * 必填，签名
     */
    @XmlElement(name = "sign")
    private String sign;

    /**
     * 选填，签名类型，目前支持HMAC-SHA256和MD5，默认为MD5
     */
    @XmlElement(name = "sign_type")
    private String signType;

    public String getAppid() {
        return appid;
    }

    public CloseOrderReq setAppid(String appid) {
        this.appid = appid;
        return this;
    }

    public String getMchid() {
        return mchid;
    }

    public CloseOrderReq setMchid(String mchid) {
        this.mchid = mchid;
        return this;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public CloseOrderReq setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
        return this;
    }

    public String getNonceStr() {
        return nonceStr;
    }

    public CloseOrderReq setNonceStr(String nonceStr) {
        this.nonceStr = nonceStr;
        return this;
    }

    public String getSign() {
        return sign;
    }

    public CloseOrderReq setSign(String sign) {
        this.sign = sign;
        return this;
    }

    public String getSignType() {
        return signType;
    }

    public CloseOrderReq setSignType(String signType) {
        this.signType = signType;
        return this;
    }

    public static void main(String[] args){
        CloseOrderReq req = new CloseOrderReq();
        req.setAppid("appid");
        req.setMchid("mc");
        System.out.println(XmlUtils.toXml(req));
    }
}

