package com.rocoinfo.weixin.msg.resp;

import com.rocoinfo.weixin.util.CDataAdapter;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * <dl>
 * <dd>Description: 回复视频消息</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/17 下午1:59</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
@XmlRootElement(name = "xml")
public class VideoResponse extends BaseResponse {

    public VideoResponse() {
        super();
    }

    public VideoResponse(String fromUser, String toUser, String createTime, String msgType, Video video) {
        super(fromUser, toUser, createTime, msgType);
        this.video = video;
    }

    /**
     * 视频信息
     */
    private Video video;

    public static class Video {

        public Video() {
            super();
        }

        public Video(String mediaId, String title, String description) {
            this.mediaId = mediaId;
            this.title = title;
            this.description = description;
        }

        /**
         * 通过素材管理接口上传多媒体文件，得到的id
         */
        private String mediaId;

        /**
         * 视频消息的标题
         */
        private String title;

        /**
         * 视频消息的描述
         */
        private String description;

        @XmlElement(name = "MediaId")
        @XmlJavaTypeAdapter(CDataAdapter.class)
        public String getMediaId() {
            return mediaId;
        }

        public void setMediaId(String mediaId) {
            this.mediaId = mediaId;
        }

        @XmlElement(name = "Title")
        @XmlJavaTypeAdapter(CDataAdapter.class)
        public String getTitle() {
            return title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        @XmlElement(name = "Description")
        @XmlJavaTypeAdapter(CDataAdapter.class)
        public String getDescription() {
            return description;
        }

        public void setDescription(String description) {
            this.description = description;
        }
    }

    @XmlElement(name = "Video")
    public Video getVideo() {
        return video;
    }

    public void setVideo(Video video) {
        this.video = video;
    }
}
