package com.rocoinfo.weixin.util;

/**
 * <dl>
 * <dd>Description: String 工具类</dd>
 * <dd>Company: 大城若谷信息技术有限公司</dd>
 * <dd>@date：2017/3/7 下午1:14</dd>
 * <dd>@author：Aaron</dd>
 * </dl>
 */
public class StringUtils {

    public static final String BLANK = "";

    private StringUtils() {
        super();
    }

    public static boolean isBlank(final CharSequence cs) {
        int strLen;
        if (cs == null || (strLen = cs.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; i++) {
            if (Character.isWhitespace(cs.charAt(i)) == false) {
                return false;
            }
        }
        return true;
    }

    public static boolean isNotBlank(final CharSequence cs) {
        return !isBlank(cs);
    }

    public static boolean isAnyBlank(CharSequence... cs) {
        for (CharSequence c : cs) {
            if (isBlank(c))
                return true;
        }
        return false;
    }

    public static boolean isNoneBlank(CharSequence... cs) {
        for (CharSequence c : cs) {
            if (isBlank(c))
                return false;
        }
        return true;
    }
}
