/*
 * Decompiled with CFR 0.152.
 */
package com.rocoinfo.weixin.api;

import com.rocoinfo.weixin.api.BaseApi;
import com.rocoinfo.weixin.model.ApiResult;
import com.rocoinfo.weixin.util.HttpUtils;
import com.rocoinfo.weixin.util.JsonUtils;
import com.rocoinfo.weixin.util.StringUtils;
import java.util.HashMap;

public class QrcodeApi
extends BaseApi {
    private static final String QRCODE_URL = "https://api.weixin.qq.com/cgi-bin/qrcode/create?access_token=";
    private static String SHOW_QRCODE_URL = "https://mp.weixin.qq.com/cgi-bin/showqrcode?ticket=";

    private QrcodeApi() {
    }

    public static ApiResult create(String json) {
        String url = QRCODE_URL + QrcodeApi.getAccessToken();
        return ApiResult.build(HttpUtils.post(url, json));
    }

    public static ApiResult createTemporary(long expireSeconds, long sceneId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("expire_seconds", expireSeconds);
        params.put("action_name", "QR_SCENE");
        HashMap actionInfo = new HashMap();
        HashMap<String, Long> scene = new HashMap<String, Long>();
        scene.put("scene_id", sceneId);
        actionInfo.put("scene", scene);
        params.put("action_info", actionInfo);
        return QrcodeApi.create(JsonUtils.toJson(params));
    }

    public static ApiResult createPermanent(long sceneId) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("action_name", "QR_LIMIT_SCENE");
        HashMap actionInfo = new HashMap();
        HashMap<String, Long> scene = new HashMap<String, Long>();
        scene.put("scene_id", sceneId);
        actionInfo.put("scene", scene);
        params.put("action_info", actionInfo);
        return QrcodeApi.create(JsonUtils.toJson(params));
    }

    public static ApiResult createPermanent(String sceneStr) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("action_name", "QR_LIMIT_STR_SCENE");
        HashMap actionInfo = new HashMap();
        HashMap<String, String> scene = new HashMap<String, String>();
        scene.put("scene_str", sceneStr);
        actionInfo.put("scene", scene);
        params.put("action_info", actionInfo);
        return QrcodeApi.create(JsonUtils.toJson(params));
    }

    public static String showQrcodeUrl(String ticket) {
        if (StringUtils.isBlank(ticket)) {
            return "";
        }
        return SHOW_QRCODE_URL + ticket;
    }
}

